extends Button

enum States {EMPTY, LISTENING, RECORDING, PLAY}
var state: States = States.EMPTY

var recording := []
var startTime := 0

func update_state(newState: States, newText: String):
	state = newState
	text = newText

func _on_button_down() -> void:
	match state:
		States.EMPTY:
			update_state(States.LISTENING, "Listening...")
		States.LISTENING:
			update_state(States.EMPTY, "Start Recording")
		States.RECORDING:
			update_state(States.PLAY, "PlayBack")
			print(recording)
	
func record(action : String, now, type):
	if state == States.RECORDING:
		recording.append([action, now - startTime, type])

func _unhandled_input(event: InputEvent) -> void:
	if event is InputEventKey:
		for action in InputMap.get_actions():
			if action.split("_")[0] == "key":
				var now = Time.get_ticks_msec()
				if Input.is_action_just_pressed(action):
					if state == States.LISTENING:
						update_state(States.RECORDING, "Stop Recording")
						startTime = now
					record(action, now, "p")
				elif Input.is_action_just_released(action):
					record(action, now, "r")
