extends Node3D

var notes_sound := {
	"C4": null, "C#4": null, "D4": null, "D#4": null, "E4": null,
	"F4": null, "F#4": null, "G4": null, "G#4": null, "A4": null,
	"A#4": null, "B4": null,

	"C5": null, "C#5": null, "D5": null, "D#5": null, "E5": null,
	"F5": null, "F#5": null, "G5": null, "G#5": null, "A5": null,
	"A#5": null, "B5": null,

	"C6": null, "C#6": null, "D6": null, "D#6": null, "E6": null,
	"F6": null, "F#6": null, "G6": null, "G#6": null, "A6": null,
	"A#6": null, "B6": null,
}
var notes_player := {}
var held_notes := []
var hold := false
var glow_material := preload("res://Piano/light_up.tres")

func _ready():
	for note in notes_sound.keys():
		var resource_path := "res://Piano/Audio/%s.wav" % note
		if ResourceLoader.exists(resource_path):
			notes_sound[note] = load(resource_path)

func note_animation_up(note: String):
	var node := get_node_or_null(note)
	if node:
		node.set("material_override", "")
		create_tween().tween_property(node, "rotation", Vector3(0, 0, 0) , 0.1)

func note_animation_down(note: String):
	var node := get_node_or_null(note)
	if node:
		node.set("material_override", glow_material)
		create_tween().tween_property(node, "rotation", Vector3(deg_to_rad(6), 0, 0), 0.1)

func note_play_sound(note) :
	if note in notes_sound:
		note_stop_sound(note)
		var audio_player = AudioStreamPlayer.new()
		audio_player.stream = notes_sound[note]
		audio_player.bus = "Master"
		add_child(audio_player)
		audio_player.play()
		notes_player[note] = audio_player

func note_stop_sound(note) :
	if note in notes_player:
		var audio_player = notes_player[note]
		notes_player.erase(note)
		var tween := create_tween()
		tween.tween_property(audio_player, "volume_db", -80, 1)
		tween.connect("finished", free_sound.bind(audio_player))

func free_sound(audio_player):
	audio_player.stop()
	audio_player.queue_free()

func release_hold():
	hold = false
	for note in held_notes : 
		note_stop_sound(note)
	held_notes.clear()

func _input(event):
	if event is InputEventKey:
		for note in notes_sound.keys():
			if Input.is_action_just_pressed("key_" + note):
				held_notes.erase(note)
				note_play_sound(note)
				note_animation_down(note)

			elif Input.is_action_just_released("key_" + note):
				if hold and note not in held_notes:
					held_notes.append(note)
				else:
					note_stop_sound(note)
				note_animation_up(note)

		if Input.is_action_just_pressed("key_Damper"):
			hold = true
		elif Input.is_action_just_released("key_Damper"):
			release_hold()
