extends Control

@onready var host_button = $HostButton
@onready var join_button = $JoinButton
@onready var ip_input = $IPInput
@onready var players_label = $PlayersLabel

var peer = ENetMultiplayerPeer.new()
var is_host = false
var players = {}

func _ready():
	host_button.pressed.connect(_on_host_pressed)
	join_button.pressed.connect(_on_join_pressed)
	multiplayer.peer_connected.connect(_on_player_connected)
	multiplayer.peer_disconnected.connect(_on_player_disconnected)

func _on_host_pressed():
	peer.create_server(7777)
	multiplayer.multiplayer_peer = peer
	is_host = true
	players[multiplayer.get_unique_id()] = "Host"
	update_players_label()

func _on_join_pressed():
	var ip = ip_input.text
	if ip.strip_edges() == "":
		print("Enter a valid IP address.")
		return
	peer.create_client(ip, 7777)
	multiplayer.multiplayer_peer = peer

func _on_player_connected(id):
	players[id] = "Player " + str(id)
	update_players_label()

func _on_player_disconnected(id):
	players.erase(id)
	update_players_label()

func update_players_label():
	var text = "Players:\n"
	for id in players:
		text += players[id] + "\n"
	players_label.text = text
