extends Node

@onready var players = {}

var peer = ENetMultiplayerPeer.new()
var is_host = false

func ready():
	multiplayer.peer_connected.connect(_on_player_connected)
	multiplayer.peer_disconnected.connect(_on_player_disconnected)
	
func host_game(port = 7777):
	peer.create_server(port)
	multiplayer.multiplayer_peer = peer
	is_host = true
	print("hosting on IP:", IP.get_local_addresses()) #Va envoyer l'IP du host
	players[multiplayer.get_unique_id()] = "Host"

func join_game(ip, port = 7777):
	peer.create_client(ip, port)
	multiplayer.multiplayer_peer = peer
	
func _on_player_connected(id):
	players[id] = "player " + str(id)
	print("player joined:", id)	
func _on_player_disconnected(id):
	players.erase(id)
	print("player disconnected:", id)
